/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.boot.nacos.actuate.endpoint;

import com.alibaba.boot.nacos.common.PropertiesUtils;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.nacos.api.config.annotation.NacosConfigListener;
import com.alibaba.nacos.api.config.annotation.NacosConfigurationProperties;
import com.alibaba.nacos.spring.context.event.config.NacosConfigMetadataEvent;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.type.AnnotationMetadata;
import org.w3c.dom.Element;

@Endpoint(id="nacos-config")
public class NacosConfigEndpoint
implements ApplicationListener<NacosConfigMetadataEvent> {
    @Autowired
    private ApplicationContext applicationContext;
    private Map<String, JSONObject> nacosConfigMetadataMap = new HashMap<String, JSONObject>(8);

    @ReadOperation
    public Map<String, Object> invoke() {
        HashMap<String, Object> result = new HashMap<String, Object>(8);
        if (!ClassUtils.isAssignable(this.applicationContext.getEnvironment().getClass(), ConfigurableEnvironment.class)) {
            result.put("error", "environment type not match ConfigurableEnvironment: " + this.applicationContext.getEnvironment().getClass().getName());
        } else {
            result.put("nacosConfigMetadata", this.nacosConfigMetadataMap.values());
            result.put("nacosConfigGlobalProperties", PropertiesUtils.extractSafeProperties((Properties)((Properties)this.applicationContext.getBean("globalNacosProperties$config", Properties.class))));
        }
        return result;
    }

    public void onApplicationEvent(NacosConfigMetadataEvent event) {
        String key = this.buildMetadataKey(event);
        if (StringUtils.isNotEmpty((CharSequence)key) && !this.nacosConfigMetadataMap.containsKey(key)) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("groupId", (Object)event.getGroupId());
            jsonObject.put("dataId", (Object)event.getDataId());
            if (ClassUtils.isAssignable(event.getSource().getClass(), AnnotationMetadata.class)) {
                jsonObject.put("origin", (Object)"NacosPropertySource");
                jsonObject.put("target", (Object)((AnnotationMetadata)event.getSource()).getClassName());
            } else if (ClassUtils.isAssignable(event.getSource().getClass(), NacosConfigListener.class)) {
                jsonObject.put("origin", (Object)"NacosConfigListener");
                Method configListenerMethod = (Method)event.getAnnotatedElement();
                jsonObject.put("target", (Object)(configListenerMethod.getDeclaringClass().getName() + ":" + configListenerMethod.toString()));
            } else if (ClassUtils.isAssignable(event.getSource().getClass(), NacosConfigurationProperties.class)) {
                jsonObject.put("origin", (Object)"NacosConfigurationProperties");
                jsonObject.put("target", (Object)event.getBeanType().getName());
            } else if (ClassUtils.isAssignable(event.getSource().getClass(), Element.class)) {
                jsonObject.put("origin", (Object)"NacosPropertySource");
                jsonObject.put("target", (Object)event.getXmlResource().toString());
            } else {
                throw new RuntimeException("unknown NacosConfigMetadataEvent");
            }
            this.nacosConfigMetadataMap.put(key, jsonObject);
        }
    }

    private String buildMetadataKey(NacosConfigMetadataEvent event) {
        if (event.getXmlResource() != null) {
            return event.getGroupId() + "|" + event.getDataId() + "|" + event.getXmlResource();
        }
        if (event.getBeanType() == null && event.getAnnotatedElement() == null) {
            return "";
        }
        return event.getGroupId() + "|" + event.getDataId() + "|" + event.getBeanType() + "|" + event.getAnnotatedElement();
    }
}

